/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.StringTextComponent;

public class MultiSelectListView<T>
extends Widget {
    private final FontRenderer font;
    private final List<T> entries;
    private final List<T> selection;
    private Function<T, String> formatter;
    private ISelectHandler<T> selectHandler;
    private final int displayLimit;
    private int scroll;

    public MultiSelectListView(FontRenderer font, int x, int y, int width, int height, List<T> entries) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.font = font;
        this.entries = entries;
        this.selection = new ArrayList<T>();
        this.displayLimit = height / 15;
        this.formatter = Object::toString;
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        MultiSelectListView.func_238467_a_((MatrixStack)stack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)-3289651);
        MultiSelectListView.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-16777216);
        for (int i = this.scroll; i < Math.min(this.scroll + this.displayLimit, this.entries.size()); ++i) {
            int j = i - this.scroll;
            T t = this.entries.get(i);
            String text = this.formatter.apply(t);
            boolean selected = this.isSelected(t);
            if (selected) {
                MultiSelectListView.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + j * 15), (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + (j + 1) * 15), (int)-1979711489);
            } else {
                int y1 = this.field_230691_m_ + j * 15;
                int y2 = y1 + 15;
                if (mouseX >= this.field_230690_l_ && mouseX <= this.field_230690_l_ + this.field_230688_j_ && mouseY >= y1 && mouseY < y2) {
                    MultiSelectListView.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)y1, (int)(this.field_230690_l_ + this.field_230688_j_), (int)y2, (int)0x67FFFFFF);
                }
            }
            this.font.func_238405_a_(stack, text, (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 3 + j * 15), 0xFFFFFF);
        }
        this.drawScrollbar(stack);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        int index = (int)(mouseY - (double)this.field_230691_m_) / 15;
        int offsetIndex = this.scroll + index;
        if (index >= 0 && index < this.entries.size()) {
            T t = this.entries.get(offsetIndex);
            boolean ctrlDown = Screen.func_231172_r_();
            if (this.isSelected(t)) {
                if (!ctrlDown) {
                    this.selection.clear();
                } else {
                    this.selection.remove(t);
                }
            } else {
                if (!ctrlDown) {
                    this.selection.clear();
                }
                this.selection.add(t);
            }
            this.selectionChanged(t);
        } else {
            this.selection.clear();
            this.selectionChanged(null);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (amount != 0.0 && this.func_231047_b_(mouseX, mouseY)) {
            this.onScroll((int)amount);
            return true;
        }
        return false;
    }

    public void onScroll(int amount) {
        int i = -amount;
        int j = this.scroll + i;
        if (j >= 0 && j <= this.entries.size() - this.displayLimit) {
            this.scroll = j;
        }
    }

    public List<T> getSelection() {
        return this.selection;
    }

    public void setSelectionResponder(ISelectHandler<T> handler) {
        this.selectHandler = handler;
    }

    public void setFormatter(Function<T, String> formatter) {
        this.formatter = Objects.requireNonNull(formatter);
    }

    private boolean isSelected(T t) {
        return this.selection.contains(t);
    }

    private void drawScrollbar(MatrixStack stack) {
        int left = this.field_230690_l_ + this.field_230688_j_ - 2;
        int right = left + 2;
        int top = this.field_230691_m_;
        int bottom = top + this.field_230689_k_;
        MultiSelectListView.func_238467_a_((MatrixStack)stack, (int)left, (int)top, (int)right, (int)bottom, (int)-16777216);
        double size = 1.0 / (double)this.entries.size() * (double)this.field_230689_k_;
        int scrollbarY = (int)((double)this.scroll * size);
        int scrollbarHeight = (int)Math.ceil((double)Math.min(this.displayLimit, this.entries.size()) * size);
        MultiSelectListView.func_238467_a_((MatrixStack)stack, (int)left, (int)(top + scrollbarY), (int)right, (int)(top + scrollbarY + scrollbarHeight), (int)-1);
    }

    private void selectionChanged(T element) {
        if (this.selectHandler != null) {
            this.selectHandler.onSelect(element, this.selection);
        }
    }

    @FunctionalInterface
    public static interface ISelectHandler<T> {
        public void onSelect(T var1, List<T> var2);
    }
}

